<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Payslip</title>
    <link rel="stylesheet" href="<?php echo e(url('css/payslip.css')); ?>">
</head>
<body>
<div>
    <div class="mb-5">
        <div class="text-center">
            <img src="<?php echo e(property_exists($payslip_settings, 'logo') && $payslip_settings->logo
                        ? asset($payslip_settings->logo)
                        : (property_exists($settings, 'tenant_logo') ? asset($settings->tenant_logo) : asset('images/logo/default-logo.png'))); ?>"
                 alt="logo"
                 class="img-fluid mb-2"
                 style="max-height: 100px; max-width: 150px;"
            />
            <h5 class="font-weight-bold"><?php echo e(property_exists($payslip_settings, 'title') && $payslip_settings->title ? $payslip_settings->title : $settings->tenant_name); ?></h5>
            <?php if(property_exists($payslip_settings, 'address') && $payslip_settings->address): ?>
                <p class="mb-0">
                    <?php echo e($payslip_settings->address); ?>

                </p>
            <?php else: ?>
                <p class="mb-0">
                    <?php echo e(property_exists($settings, 'address') ? $settings->address.', ' : ''); ?>

                    <?php echo e(property_exists($settings, 'area') ? $settings->area.', ' : ''); ?>

                    <?php echo e(property_exists($settings, 'city') ? $settings->city : ''); ?> <br/>
                    <?php echo e(property_exists($settings, 'zip_code') ? 'ZIP-code:'.$settings->zip_code.', ' : ''); ?>

                    <?php echo e(property_exists($settings, 'country') ? $settings->country : ''); ?>

                </p>
            <?php endif; ?>
        </div>
    </div>
    <div class="custom-row employee-info">
        <div class="column">
            <div class="mt-2">
                <img src="<?php echo e($payslip->user->profilePicture ? asset($payslip->user->profilePicture->path) : asset('images/avatar.png')); ?>"
                     class="rounded-circle"
                     width="40"
                     height="40"
                     alt="">
                <div class="d-inline-block ml-1">
                    <p class="small text-primary" style="margin-bottom: -7px"><?php echo e($payslip->user->full_name); ?></p>
                    <small class="text-muted"><?php echo e($payslip->user->email); ?></small>
                </div>
            </div>
        </div>
        <div class="column">
            <div class="pl-5">
                <p class="small mb-0">
                    <span class="text-muted"><?php echo e(__t('payslip_for')); ?>:</span> <span
                            class="text-info"><?php echo e($payslipFor); ?></span>
                </p>
                <p class="small mb-0">
                    <span class="text-muted"><?php echo e(__t('created_at')); ?>:</span> <?php echo e($payslip->created_at->format('d M,Y')); ?>

                </p>
            </div>
        </div>
        <div class="column">
            <div class="float-right">
                <p class="small mb-0">
                    <span class="text-muted"><?php echo e(__t('designation')); ?>:</span> <?php echo e($payslip->user->designation ? $payslip->user->designation->name : 'None'); ?>

                </p>
                <p class="small mb-0">
                    <span class="text-muted"><?php echo e(__t('department')); ?>:</span> <?php echo e($payslip->user->department ? $payslip->user->department->name : 'None'); ?>

                </p>
            </div>
        </div>
    </div>
    <div class="custom-row basic-salary-info border-bottom">
        <div class="column">
            <p class="mb-1"><?php echo e(__t('basic_salary')); ?></p>
        </div>
        <div class="column text-right">
            <p class="mb-1">
                <?php echo e(trans('default.like_'.$settings->currency_position, [
                    'symbol' => $settings->currency_symbol,
                     'amount' => $salaryAmount
                    ])); ?>

            </p>
        </div>
    </div>
    <?php if($payslip->consider_type != 'none'): ?>
        <div class="custom-row basic-salary-info border-bottom mt-3">
            <div class="column">
                <p class="mb-1"><?php echo e(__t('total_earning')); ?>

                    <small>(<?php echo e(__t('based_on') .' '. __t($payslip->consider_type)); ?><?php echo e(($payslip->net_salary - ($totalAllowance - $totalDeduction)) >= $salaryAmount
                            ? ', '.($payslip->consider_overtime ? __t('included_overtime') : __t('excluded_overtime'))
                            : ''); ?>)
                    </small>
                </p>
            </div>
            <div class="column text-right">
                <p class="mb-1">
                    <?php echo e(trans('default.like_'.$settings->currency_position, [
                        'symbol' => $settings->currency_symbol,
                         'amount' => round($payslip->net_salary - ($totalAllowance - $totalDeduction), 2)
                        ])); ?>

                </p>
            </div>
        </div>
    <?php endif; ?>

    <?php if(count($beneficiaries) != 0): ?>
        <div class="custom-row benificiary-info border-bottom mt-5 mb-2">
            <div class="column">
                <p class="mb-1"><?php echo e(__t('beneficiary')); ?></p>
            </div>
        </div>
        <div class="custom-row salary-details-info">
            <div class="column earnings-info pr-3">
                <table>
                    <thead>
                    <tr>
                        <td>
                            <span class="w-100 d-inline-block border-bottom pb-1"><?php echo e(__t('allowances')); ?></span>
                        </td>
                        <td class="text-right">
                            <span class="w-100 d-inline-block border-bottom pb-1 mt-10 text-white"
                                  style="margin-left: -2px;"> - </span>
                        </td>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($beneficiary->beneficiary->type == 'allowance'): ?>
                            <?php if($beneficiary->is_percentage == 1): ?>
                                <tr>
                                    <td class="small"><?php echo e($beneficiary->beneficiary->name); ?> (<?php echo e($beneficiary->amount); ?>

                                        %)
                                    </td>
                                    <td class="small text-right">
                                        <?php echo e(trans('default.like_'.$settings->currency_position, [
                                            'symbol' => $settings->currency_symbol,
                                            'amount' => round(($salaryAmount/100) * $beneficiary->amount)
                                                ])); ?>

                                    </td>
                                </tr>
                            <?php else: ?>
                                <tr>
                                    <td class="small"><?php echo e($beneficiary->beneficiary->name); ?></td>
                                    <td class="small text-right">
                                        <?php echo e(trans('default.like_'.$settings->currency_position, [
                                           'symbol' => $settings->currency_symbol,
                                           'amount' =>  $beneficiary->amount
                                               ])); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="column deductions-info pl-3">
                <table>
                    <thead>
                    <tr>
                        <td>
                            <span class="w-100 d-inline-block border-bottom pb-1"><?php echo e(__t('deductions')); ?></span>
                        </td>
                        <td class="text-right">
                            <span class="w-100 d-inline-block border-bottom pb-1 text-white" style="margin-left: -2px;">-</span>
                        </td>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($beneficiary->beneficiary->type == 'deduction'): ?>
                            <?php if($beneficiary->is_percentage == 1): ?>
                                <tr>
                                    <td class="small"><?php echo e($beneficiary->beneficiary->name); ?> (<?php echo e($beneficiary->amount); ?>

                                        %)
                                    </td>
                                    <td class="small text-right">
                                        <?php echo e(trans('default.like_'.$settings->currency_position, [
                                          'symbol' => $settings->currency_symbol,
                                          'amount' =>  round(($salaryAmount/100) * $beneficiary->amount, 2)
                                              ])); ?>

                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php
                                    settings()
                                ?>
                                <tr>
                                    <td class="small"><?php echo e($beneficiary->beneficiary->name); ?></td>
                                    <td class="small text-right">
                                        <?php echo e(trans('default.like_'.$settings->currency_position, [
                                          'symbol' => $settings->currency_symbol,
                                          'amount' =>  $beneficiary->amount
                                              ])); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="custom-row earning-deduction-info mb-3">
            <div class="column pr-3">
                <table>
                    <tbody>
                    <tr>
                        <td class="pt-2"><?php echo e(__t('total_allowance')); ?></td>
                        <td class="text-right pt-2">
                            <?php echo e(trans('default.like_'.$settings->currency_position, [
                                'symbol' => $settings->currency_symbol,
                                'amount' =>  round($totalAllowance, 2)
                                    ])); ?>

                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="column pl-3">
                <table>
                    <tbody>
                    <tr>
                        <td class="pt-2"><?php echo e(__t('total_deduction')); ?></td>
                        <td class="text-right pt-2">
                            <?php echo e(trans('default.like_'.$settings->currency_position, [
                                'symbol' => $settings->currency_symbol,
                                'amount' =>  round($totalDeduction, 2)
                                    ])); ?>

                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="custom-row total-benificiary-info border-bottom">
            <div class="column">
                <p class="mb-1"><?php echo e(__t('beneficiary_amount')); ?></p>
            </div>
            <div class="column text-right">
                <p class="mb-1">
                    <?php echo e(trans('default.like_'.$settings->currency_position, [
                            'symbol' => $settings->currency_symbol,
                            'amount' =>  round($totalAllowance - $totalDeduction, 2)
                                ])); ?>

                </p>
            </div>
        </div>
    <?php endif; ?>

    <div class="custom-row net-salary-info border-bottom mb-5 mt-5">
        <div class="column">
            <p class="mb-1"><?php echo e(__t('net_payable_salary')); ?></p>
        </div>
        <div class="column text-right">
            <p class="mb-1">
                <?php echo e(trans('default.like_'.$settings->currency_position, [
                        'symbol' => $settings->currency_symbol,
                        'amount' =>  round($payslip->net_salary, 2)
                            ])); ?>

            </p>
        </div>
    </div>

    <?php if(property_exists($payslip_settings, 'note') && $payslip_settings->note): ?>
        <hr class="mb-0">
        <small class="font-italic"><b>Note: </b><?php echo e($payslip_settings->note); ?></small>
    <?php endif; ?>
</div>

</body>
</html><?php /**PATH /home/homecar1/hrm.myne.co.ke/src/resources/views/tenant/payroll/pdf/payslip.blade.php ENDPATH**/ ?>